<?php
require("./config/session.php");
require("./config/connection.php");

// Verify user is logged in
confirm_logged_in();

// Verify CSRF token
if (!csrf_verify($_POST['csrf_token'] ?? null)) {
    http_response_code(403);
    die('Invalid CSRF token');
}

// Get appname
$query = "SELECT appname FROM app_settings";
$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];

// Configuration
$maxFileSize = 5 * 1024 * 1024; // 5MB
$allowedMimeTypes = [
    'image/jpeg',
    'image/png',
    'image/gif',
    'image/webp',
    'image/svg+xml'
];
$allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle App Icon Image Upload
    if (isset($_FILES['app_icon_image'])) {
        $appIconImage = $_FILES['app_icon_image'];

        // Check for errors
        if ($appIconImage['error'] === UPLOAD_ERR_OK) {
            // Validate file size
            if ($appIconImage['size'] > $maxFileSize) {
                header('Location: ./pages/app_settings.php?error=file_too_large');
                exit();
            }

            // Validate MIME type
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mimeType = finfo_file($finfo, $appIconImage['tmp_name']);
            finfo_close($finfo);

            if (!in_array($mimeType, $allowedMimeTypes)) {
                header('Location: ./pages/app_settings.php?error=invalid_file_type');
                exit();
            }

            // Validate extension
            $extension = strtolower(pathinfo($appIconImage['name'], PATHINFO_EXTENSION));
            if (!in_array($extension, $allowedExtensions)) {
                header('Location: ./pages/app_settings.php?error=invalid_extension');
                exit();
            }

            // Define the upload directory
            $uploadDir = 'uploads/app_icons/';

            // Create the directory if it doesn't exist
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            // Generate a secure filename
            $appIconFilename = bin2hex(random_bytes(16)) . '_' . time() . '.' . $extension;

            // Move the uploaded file to the destination directory
            $appIconFilePath = $uploadDir . $appIconFilename;
            if (!move_uploaded_file($appIconImage['tmp_name'], $appIconFilePath)) {
                header('Location: ./pages/app_settings.php?error=upload_failed');
                exit();
            }

            // Save the image file path URL to the database
            $appIconFilePathURL = $baseUrl . '/' . $appIconFilePath;

            $sql = "UPDATE app_settings SET app_icon = ?";
            $stmt = $mysqli->prepare($sql);
            $stmt->bind_param("s", $appIconFilePathURL);
            $stmt->execute();
            $stmt->close();
        }
    }

    // Handle Banner Image Upload
    if (isset($_FILES['banner_image'])) {
        $bannerImage = $_FILES['banner_image'];

        // Check for errors
        if ($bannerImage['error'] === UPLOAD_ERR_OK) {
            // Validate file size
            if ($bannerImage['size'] > $maxFileSize) {
                header('Location: ./pages/app_settings.php?error=file_too_large');
                exit();
            }

            // Validate MIME type
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mimeType = finfo_file($finfo, $bannerImage['tmp_name']);
            finfo_close($finfo);

            if (!in_array($mimeType, $allowedMimeTypes)) {
                header('Location: ./pages/app_settings.php?error=invalid_file_type');
                exit();
            }

            // Validate extension
            $extension = strtolower(pathinfo($bannerImage['name'], PATHINFO_EXTENSION));
            if (!in_array($extension, $allowedExtensions)) {
                header('Location: ./pages/app_settings.php?error=invalid_extension');
                exit();
            }

            // Define the upload directory
            $uploadDir = 'uploads/banners/';

            // Create the directory if it doesn't exist
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            // Generate a secure filename
            $bannerFilename = bin2hex(random_bytes(16)) . '_' . time() . '.' . $extension;

            // Move the uploaded file to the destination directory
            $bannerFilePath = $uploadDir . $bannerFilename;
            if (!move_uploaded_file($bannerImage['tmp_name'], $bannerFilePath)) {
                header('Location: ./pages/app_settings.php?error=upload_failed');
                exit();
            }

            // Save the image file path URL to the database
            $bannerFilePathURL = $baseUrl . '/' . $bannerFilePath;

            $sql = "UPDATE app_settings SET banner_image = ?";
            $stmt = $mysqli->prepare($sql);
            $stmt->bind_param("s", $bannerFilePathURL);
            $stmt->execute();
            $stmt->close();
        }
    }

    // Redirect with success message
    header('Location: ./pages/app_settings.php?success=1');
    exit();
} else {
    // Only POST requests allowed
    http_response_code(405);
    die('Method not allowed');
}
?>